<?php

namespace Fivable\Scaffolding\Traits;

use Carbon\Carbon;
use Firebase\JWT\JWT;
use Fivable\Scaffolding\Models\JwtToken;
use Illuminate\Encryption\Encrypter;
use Illuminate\Support\Str;

trait HandlesTokens {
    /**
     * Creates a new JwtToken (Object/Model)
     *
     * @param  int    $userId
     * @param  Carbon $expiry
     * @return JwtToken
     */
    private function createJwtObject(int $userId, Carbon $expiry): JwtToken
    {
        return JwtToken::create([
            'jwt_token' => $this->createToken($userId, $expiry),
            'user_id' => $userId,
            'expiry' => $expiry,
        ]);
    }

    /**
     * Creates a JWT token (string)
     *
     * @param  int      $userId
     * @param  Carbon   $expiration
     * @return string
     */
    private function createToken(int $userId, Carbon $expiration): string
    {
        $key = config('app.key');
        if (Str::startsWith($key, 'base64:')) {
            $key = base64_decode(substr($key, 7));
        }
        $encrypter = new Encrypter($key, config('app.cipher'));

        return JWT::encode([
            'sub' => $userId,
            'expiry' => $expiration->getTimestamp(),
        ], $encrypter->getKey());
    }
}
