<?php

namespace Fivable\Scaffolding\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\User;

class LoginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        $this->transform();
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'email' => 'string|required',
            'password' => 'string|required',
        ];
    }

    /**
     * Transform this Request's input here
     */
    public function transform()
    {
        $email = $this->input('email');
        if (! is_null($email)) {
            $user = User::where('email', $email)
                        ->orWhere('username', $email)
                        ->first();
            if (! is_null($user)) {
                $this->merge(['email' => $user->email]);
            }
        }
    }
}
