<?php

namespace Fivable\Scaffolding\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static Builder where(string $columnName, $value)
 * @method static JwtToken create(array $array)
 * @property string $jwt_token
 */
class JwtToken extends Model
{
    /** @var array - Columns to convert to Carbon when retrieved */
    protected $dates = ['expiry'];

    /** @var array - Mass-assignable fields */
    protected $fillable = [
        'jwt_token',
        'user_id',
        'expiry',
    ];

    /**
     * Return the User associated with the JwtToken
     *
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo('App\User');
    }
}
