<?php

namespace Fivable\Scaffolding;

use Illuminate\Support\ServiceProvider;

class ScaffoldingServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services
     * @return void
     */
    public function boot()
    {
        // Load routes unless they are already cached
        $this->loadRoutesFrom(__DIR__.'/routes.php');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__.'/migrations');

        // Load views
        $this->loadViewsFrom(__DIR__.'/views', 'scaffolding');

        // Specify where to publish Scaffolding config and views for customization
        // 'scaffolding' is set as the tag for these vendor files, allowing you
        // to publish config and views with vendor:publish --tag=scaffolding
        $this->publishes([
            __DIR__.'/config/scaffolding.php' => config_path('scaffolding.php'),
            __DIR__.'/views' => resource_path('views/vendor/scaffolding'),
        ], 'scaffolding');

        // Add artisan commands if necessary
        if ($this->app->runningInConsole()) {
            $this->commands([
                // CommandName::class,
            ]);
        }
    }

    /**
     * Register the application services.
     * @return void
     */
    public function register()
    {
        // Create alias to Scaffolding class for ScaffoldingFacade to use
        $this->app->alias(Scaffolding::class, 'scaffolding');

        // Merge the default Scaffolding config file with
        // published config so that you only need to
        // define the keys you plan to overwrite
        $this->mergeConfigFrom(__DIR__.'/config/scaffolding.php', 'scaffolding');

        //Register Authenticate middleware
        $this->app['router']->aliasMiddleware('authenticate', Middleware\Authenticate::class);
        //Register InsertToken middleware
        $this->app['router']->aliasMiddleware('insert-token', Middleware\InsertToken::class);
    }
}
