<?php

namespace Fivable\Scaffolding\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        $this->transform();
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'email' => 'string|required_without:username|exists:users,email',
            'username' => 'string|required_without:email|exists:users,username',
            'password' => 'string|required',
        ];
    }

    /**
     * Transform this Request's input here
     */
    public function transform()
    {
        if (is_null($this->input('email')) && ! is_null($this->input('username'))) {
            $email = DB::table('users')->select('email')
                       ->where('username', $this->input('username'))
                       ->first();
            $this->merge(compact('email'));
        }
    }
}
