<?php

namespace Fivable\Scaffolding\Middleware;

use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Closure;
use App\User;
use Fivable\Scaffolding\Models\JwtToken;

class Authenticate
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // If we've already authenticated with some other middleware
        // for [whatever] reason, let's get straight to it!
        if (!is_null(Auth::user())) {
            return $next($request);
        }

        $bearer_token = $request->bearerToken();

        if (!is_null($bearer_token) || $bearer_token != "") {

            // Pull the JWT based on the bearer token
            $jwt_token = JwtToken::where('jwt_token', $bearer_token)->first();
            if ($jwt_token == null) {
                return response()->json(['error' => 'token not found in database'], 401);
            }

            // Check if the token is expired
            if (Carbon::now()->gt($jwt_token->expiry)) {
                return response()->json(['error' => 'token has expired'], 401);
            }

            // Get the user corresponding to the JWT
            $user = User::where('id', $jwt_token->user_id)->first();
            if ($user == null) {
                return response()->json(['error' => 'invalid user'], 401);
            }
            Auth::loginUsingId($user->id);


        } else {
            return response()->json(['error' => 'missing or empty token'], 401);
        }

        return $next($request);
    }
}
