<?php

namespace Fivable\Scaffolding\Traits;

use Illuminate\Support\Facades\Auth;
use Fivable\Scaffolding\Models\JwtToken;

trait HasUser {

    /**
     * Access the Current User associated with the bearer token
     * OR attempts to access the current session user. If both exist,
     * they should be the same user.
     * @return User     Null if none found
     */
    protected function user()
    {
        $bearer_token = request()->bearerToken();
        $jwt_token = JwtToken::where('jwt_token', $bearer_token)->first();
        $user = Auth::user();

        if (is_null($jwt_token)) {
            if (!is_null($user)) {
                return $user;
            } else {
                return null;
            }
        }
        else {
            return $jwt_token->user;
        }
    }

}
