<?php

/**
 * Scaffolding Configuration
 * ------------------------------
 *
 * When editing this config file you do
 * not need to include keys you do not
 * want to override, unless nested
 *
 * NOTE: Don't use closures in config file
 * They can not be serialized correctly
 * with php artisan config:cache cmd
 */

return [

    // Specify if you would like to use Scaffolding as a headless API.
    // If you do this, some routes that do not have '/api' preceding the URI
    // will become API routes. We do not automatically append /api under the covers
    // because we want this configuration file to maintain the ability to customize URIs 100%
    'headless-api' => false,

    // If using headless-api, make sure you specify the base URL
    // of the front-end / head
    'head-url' => env('HEAD_URL', ''),

    // Specify which package's published views to retrieve scaffolding views from,
    // This is meant for packages like Buildavel which would want to override
    // these views from a package. Does not apply if headless-api
    'get_views_from' => 'scaffolding',

    // Use Scaffolding's Default Homepage View
    // Set this to false to be able to use your own homepage in your routes file
    // If you set this to false, verify the home URI in the routes array matches your custom route
    'default-homepage' => true,

    // URIs for Scaffolding Routes
    // The keys are the route 'names' hard-coded under the covers
    // GET reset-password and POST verify-reset-password URIs are generated, and cannot be customized
    'routes' => [

        // GET Login Page
        // (not used if headless)
        'login' => 'auth/login',

        // POST Login Form
        'post-login' => 'login',

        // POST Logout
        'post-logout' => 'logout',

        // GET Forgot Password Page
        // (not used if headless)
        'forgot-password' => 'auth/forgot-password',

        // POST Forgot Password Page
        'post-forgot-password' => 'forgot-password',

        // POST Reset Password form
        'post-reset-password' => 'reset-password',

        // GET Scaffolding's Default Home Page
        // (not used if headless)
        'home' => 'admin',

        // GET whoami
        'whoami' => 'api/whoami'

    ],

];
