<?php

/**
 * Scaffolding Routes
 * --------------------
 *
 * These routes will be bootstrapped in
 * from Scaffolding's Service Provider
 * unless they are already cached
 */

 /**
  * Web Routes
  * ----------
  */
 if (!config('scaffolding.headless-api')) {
     Route::middleware(['web'])->group(function() {

         // Unauthenticated
         Route::get(config('scaffolding.routes.login'), 'Fivable\Scaffolding\Controllers\ApiController@getLogin')->name('login');
         Route::get(config('scaffolding.routes.forgot-password'), 'Fivable\Scaffolding\Controllers\ApiController@getForgotPassword')->name('forgot-password');
         Route::post(config('scaffolding.routes.post-login'), 'Fivable\Scaffolding\Controllers\ApiController@login')->name('post-login');
         Route::post(config('scaffolding.routes.post-forgot-password'),'Fivable\Scaffolding\Controllers\ApiController@forgotPassword')->name('post-forgot-password');

         // NOTE: GET Reset Password Page route is NOT customizable AKA does not use config
         Route::get('reset-password/{hash}/{url_encoded_email}','Fivable\Scaffolding\Controllers\ApiController@getResetPassword')->name('reset-password');
         Route::post(config('scaffolding.routes.post-reset-password'), 'Fivable\Scaffolding\Controllers\ApiController@resetPassword')->name('post-reset-password');

         // Authenticated
         Route::middleware(['auth', 'insert-token'])->group(function() {
             Route::post(config('scaffolding.routes.post-logout'), 'Fivable\Scaffolding\Controllers\ApiController@logout')->name('post-logout');
             if (config('scaffolding.default-homepage')) {
                 Route::get(config('scaffolding.routes.home'), 'Fivable\Scaffolding\Controllers\ApiController@defaultHome')->name('home');
             }
         });

     });
 }

 /**
  * API Routes
  * ----------
  */
 Route::middleware(['api'])->group(function() {

     // Unauthenticated
     if (config('scaffolding.headless-api')) {
         Route::post(config('scaffolding.routes.post-login'), 'Fivable\Scaffolding\Controllers\ApiController@login')->name('post-login');
         Route::post(config('scaffolding.routes.post-forgot-password'), 'Fivable\Scaffolding\Controllers\ApiController@forgotPassword')->name('post-forgot-password');
         // NOTE: POST Verify Reset Password route is NOT customizable AKA does not use config
         Route::post('verify-reset-password','Fivable\Scaffolding\Controllers\ApiController@verifyResetPassword')->name('verify-reset-password');
         Route::post(config('scaffolding.routes.post-reset-password'), 'Fivable\Scaffolding\Controllers\ApiController@resetPassword')->name('post-reset-password');
     }

     // Authenticated (authenticate is the auth middleware for our custom JWT stuff)
     Route::middleware(['authenticate'])->group(function() {
         Route::get(config('scaffolding.routes.whoami'), 'Fivable\Scaffolding\Controllers\ApiController@whoami')->name('whoami');

         if (config('scaffolding.headless-api')) {
             Route::post(config('scaffolding.routes.post-logout'), 'Fivable\Scaffolding\Controllers\ApiController@logout')->name('post-logout');
         }
     });

 });
