<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') . ' | ' }}@yield('title')</title>

    <!-- Scripts -->
    @if(Session::has('jwt_token'))
        <script>
            window.jwtToken = '{{ Session::get('jwt_token') }}';
        </script>
    @endif
    @yield('add_top_scripts')

    <!-- Fonts -->
    @yield('add_fonts')

    <!-- Styles -->
    @yield('add_styles')

</head>
<body>
    <div id="app">
        @if(Session::has('flash_message'))
            <div id="flash_message">
                <p>{{ Session::get('flash_message') }}</p>
            </div>
        @endif
        <main>
            @yield('content')
        </main>
    </div>

    <!-- Scripts -->
    @yield('add_bottom_scripts')
</body>
</html>
