<?php

namespace Fivable\Scaffolding\Mail;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;

use App\User;


class ForgotPassword extends Mailable
{
    use Queueable, SerializesModels;

    public $hash;
    public $email;
    public $url;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($hash, $email)
    {
        $this->hash = $hash;
        $this->email = $email;
        $this->url = url('/');
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('scaffolding::forgot-password-email');
    }
}
