<?php

/**
 * Scaffolding Configuration
 * ------------------------------
 *
 * In this file we'll set some configuration values
 * They can be published/changed via the command
 * php artisan vendor:publish --tag=scaffolding
 *
 * When publishing config file to make edits
 * you do not need to include keys you do
 * not want to override, unless nested
 *
 * NOTE: Don't use closures in config file
 * They can not be serialized correctly
 * with php artisan config:cache cmd
 */

return [

    // Specify which package's publish views to retrieve scaffolding views from
    'get_views_from' => 'scaffolding',

    // Use Scaffolding's Default Homepage View
    // Set this to false to be able to use your own homepage in your routes file
    // If you set this to false, be sure your homepage route below matches your custom route
    'default-homepage' => true,

    // URIs for Scaffolding Routes
    // NOTE: THE KEYS ARE THE ROUTE NAMES
    'routes' => [

        // GET Login Page
        'login' => 'auth/login',
        // POST Login Form
        'post-login' => 'login',
        // POST Logout
        'post-logout' => 'logout',
        // GET Forgot Password Page
        'forgot-password' => 'auth/forgot-password',
        // POST Forgot Password Page
        'post-forgot-password' => 'forgot-password',
        // NOTE: GET Reset Password is generated, and cannot be customized
        // POST Reset Password form
        'post-reset-password' => 'reset-password',
        // GET Scaffolding's Default Home Page
        'home' => 'admin',
        // GET whoami
        'whoami' => 'api/whoami'

    ],

];
