<?php

namespace Fivable\Scaffolding\Middleware;

use Illuminate\Support\Facades\Auth;

use Carbon\Carbon;
use Closure;
use Log;

use App\User;
use Fivable\Scaffolding\Models\JwtToken;

class InsertToken
{
    /**
     * Add the User's JWT Token to the outgoing request
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // $response = $next($request);

        $user = Auth::user();
        if (is_null($user)) {
            Log::error('Somebody made it into the InsertToken middleware without being logged into session');
            return $response;
        }

        $token_object = JwtToken::where('user_id', $user->id)->first();
        if (is_null($token_object)) {
            Log::error('Somebody made it into the InsertToken middleware without a JwtToken in DB');
        }

        // Touch expiry so that your JwtToken only expires after you've been
        // logged out of the session for 24 hours
        $expiry = Carbon::now()->addDays(1);
        $token_object->expiry = $expiry;
        $token_object->save();
        $jwt_token = $token_object->jwt_token;

        $request->session()->flash('jwt_token', $jwt_token);

        return $next($request);
    }
}
