<?php

namespace Fivable\FivableFiles;

use Illuminate\Support\ServiceProvider;

class FivableFilesServiceProvider extends ServiceProvider
{
    /**
     * Perform post-registration booting of services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadMigrationsFrom(__DIR__.'/../database/migrations');

        // Publishing is only necessary when using the CLI.
        if ($this->app->runningInConsole()) {
            $this->bootForConsole();
        }
    }

    /**
     * Register any package services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/fivablefiles.php', 'fivablefiles');

        // Register the service the package provides.
        $this->app->singleton('fivablefiles', function () {
            return new FivableFiles;
        });
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['fivablefiles'];
    }

    /**
     * Console-specific booting.
     *
     * @return void
     */
    protected function bootForConsole()
    {
        // Publishing the configuration file.
        $this->publishes([
            __DIR__.'/../config/fivablefiles.php' => config_path('fivablefiles.php'),
        ], 'fivablefiles-config');

        $this->publishes([
            __DIR__.'/../database/migrations' => database_path('migrations'),
        ], 'fivablefiles-migrations');

        $this->publishes([
            __DIR__.'/Controllers' => base_path('app/Http/Controllers'),
        ], 'fivablefiles-controllers');

        $this->publishes([
            __DIR__.'/Models' => base_path('app/'),
        ], 'fivablefiles-models');
    }
}
