<?php

namespace Fivable\FivableFiles\Controllers;

use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Fivable\FivableFiles\Models\File;
use Illuminate\Routing\Controller;

class FileController extends Controller
{

    /**
     * Create a new File entry in the database
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function store(Request $request): JsonResponse
    {
        $file = File::createFile($request);

        if ($file) {
            return response()->json([
                'success' => 'File created successfully.',
                'file' => $file,
            ], 200);
        }

        return response()->json([
            'error' => 'File creation failed.',
        ], 422);
    }

    /**
     * Update an existing File
     *
     * @param Request $request
     * @param File    $file
     * @return JsonResponse
     */
    public function update(Request $request, File $file): JsonResponse
    {
        if ($file->updateFile($request)) {
            return response()->json([
                'success' => 'File updated successfully.',
                'file' => $file,
            ], 200);
        }

        return response()->json([
            'error' => 'Failed to update file. Please check that your file 
            is being appended to the request with the key "file".',
        ], 500);
    }

    /**
     * Soft-deletes an existing File in the database
     *
     * @param Request $request
     * @param File    $file
     * @return JsonResponse
     */
    public function destroy(Request $request, File $file): JsonResponse
    {
        try {
            $file->delete();
            $file->deleteInStorage();
        } catch (Exception $exception) {
            return response()->json([
                'error' => $exception->getMessage(),
            ], 400);
        }

        return response()->json([
            'success' => 'File deleted successfully.',
            'deleted_at' => $file->deleted_at,
        ], 200);
    }
}
