@if(!empty($mobileMenu) && !empty($mobileMenu->content))
    <div class="mobile-menu">
        <div class="nav {{ $userLoggedIn ? 'user-logged-in' : '' }}">
            <div class="title">
                <span class="">Menu</span>
                <div class="menu-close icon-container"><i class="fa fa-times" aria-hidden="true"></i></div>
            </div>
            <div class="menu-buildable-menu-container">
                <ul id="menu-buildable-menu-1" class="menu">
                    @foreach($mobileMenu->content as $page)
                        <li class="menu-item {{ (!is_null($buildablePage) && isset($page['slug']) && $buildablePage->slug == $page['slug']) ? 'current-menu-item' : '' }}">
                            <a href="{{ isset($page['slug']) ? (env('APP_URL') . '/' . ($page['slug'])) : $page['url'] }}">{{ isset($page['customTitle']) ? $page['customTitle'] : $page['title'] }}</a>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
@elseif(!empty($header) && !empty($header->content))
    <div class="mobile-menu">
        <div class="nav {{ $userLoggedIn ? 'user-logged-in' : '' }}">
            <div class="title">
                <span class="">Menu</span>
                <div class="menu-close icon-container"><i class="fa fa-times" aria-hidden="true"></i></div>
            </div>
            <div class="menu-buildable-menu-container">
                <ul id="menu-buildable-menu-1" class="menu">
                    @foreach($header->content as $page)
                        <li class="menu-item {{ (!is_null($buildablePage) && isset($page['slug']) && $buildablePage->slug == $page['slug']) ? 'current-menu-item' : '' }}">
                            <a href="{{ isset($page['slug']) ? (env('APP_URL') . '/' . ($page['slug'])) : $page['url'] }}">{{ isset($page['customTitle']) ? $page['customTitle'] : $page['title'] }}</a>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
@endif
<div id="header" class="{{ $headerOptions }}">
    @if(!is_null($innerNav))
        <div class="inner-page-navigation">
            <div class="nav">
                <div class="menu-inner-nav-container">
                    <ul id="menu-inner-nav-1" class="menu">
                        @foreach($header->content as $page)
                            <li class="menu-item {{ (!is_null($buildablePage) && isset($page['slug']) && $buildablePage->slug == $page['slug']) ? 'current-menu-item' : '' }}">
                                <a href="{{ isset($page['slug']) ? (env('APP_URL') . '/' . ($page['slug'])) : $page['url'] }}">{{ isset($page['customTitle']) ? $page['customTitle'] : $page['title'] }}</a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif
    <div class="header-flex">
        <div class="logo-and-text {{ (!empty($mobileHeaderLogo)) ? 'has-mobile-logo' : '' }}">
            @if(!empty($headerLogo))
                <a class="logo-link" href="{{ url('/') }}"><img id="header_logo" class="logo" src="{{ json_decode($headerLogo)->url }}" /></a>
            @endif
            @if(!empty($headerText))
                <h4 class="text-link"><a href="{{ url('/') }}">{{ $headerText }}</a></h4>
            @endif
            @if(!empty($mobileLogo))
                <a class="mobile-logo-link" href="{{ url('/') }}"><img id="mobile_header_logo" class="logo" src="{{ json_decode($mobileHeaderLogo)->url }}" /></a>
            @endif
        </div>
        <div class="flex row align-center">
            @if(!empty($header) && !empty($header->content))
                <div class="header-menu">
                    <div class="menu-buildable-menu-container">
                        <ul id="menu-buildable-menu-2" class="menu">
                            @foreach($header->content as $page)
                                <li class="menu-item {{ (!is_null($buildablePage) && isset($page['slug']) && $buildablePage->slug == $page['slug']) ? 'current-menu-item' : '' }}">
                                    <a href="{{ isset($page['slug']) ? (env('APP_URL') . '/' . ($page['slug'])) : $page['url'] }}">{{ isset($page['customTitle']) ? $page['customTitle'] : $page['title'] }}</a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="mobile-menu">
                    <div class="menu-button icon-container">
                        <i class="fa fa-bars" aria-hidden="true"></i>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
