<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta property="og:type" content="website" />
    @yield('metas')



    @if (isset($isHomeRoute) && $isHomeRoute)
        <meta property="og:title" content="{{ ($siteName ?? 'Buildable')}}" />
        <title>{{ ($siteName ?? 'Buildable')}}</title>
    @else
        <meta property="og:title" content="{{ ($siteName ?? 'Buildable') . ' | ' }}@yield('title')" />
        <title>{{ ($siteName ?? 'Buildable') . ' | ' }}@yield('title')</title>
    @endif

    @yield('favicons')

    @yield('add_fonts')

    <!-- STYLES -->
    @yield('add_styles')

    <!-- SCRIPTS -->
    @if(Session::has('jwt_token'))
        <script>
            window.jwtToken = '{{ Session::get('jwt_token') }}';
            window.csrfToken = '{{ csrf_token() }}';
        </script>
    @endif
    @yield('add_top_scripts')

</head>
<body>

    @yield('content')

    <!-- Scripts -->
    @yield('add_bottom_scripts')
</body>
</html>
