@extends('buildable::default-layout')

@section('title') {{ $buildablePage->title }}@endsection

@section('metas')
  @if (isset($isHomeRoute) && $isHomeRoute)
    <meta name="description" content="{{ $siteDescription }}" />
    <meta property="og:description" content="{{ $siteDescription }}" />
  @elseif (!is_null($buildablePage->getMetaValue('SEO Description')))
    <meta name="description" content="{{ $buildablePage->getMetaValue('SEO Description') }}" />
    <meta property="og:description" content="{{ $buildablePage->getMetaValue('SEO Description') }}" />
  @endif

  @include('buildable-overrides.custom-metas')
@endsection

@section('favicons')
  <!-- Favicons -->
  @if(isset($favicon))
    <!-- Still need to figure out how we're going to do this favicon thing when it's saved in general settings -->
  @else
    @include('buildable-overrides.custom-favicons')
  @endif
@endsection('favicons')

@section('add_top_scripts')

    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
            integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8="
            crossorigin="anonymous">
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/waypoints/4.0.1/jquery.waypoints.min.js?ver=4.9.6"></script>

    <script src="{{ asset('/js/public/script.js') }}"></script>
    <script src="{{ asset('/js/public/helpers.js') }}"></script>
    <script src="{{ asset('/js/public/public.js') }}"></script>
    <script src="{{asset('/js/public/header.js')}}"></script>

    @if(isset($googleAnalyticsTrackingId))
        <script>
            (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
            (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
            m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
            })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

            ga('create', '{{ $googleAnalyticsTrackingId }}', 'auto');
            ga('send', 'pageview');
        </script>
    @endif

@endsection

@section('add_styles')

    @include('buildable-overrides.prepend-styles')

    @php
        $fontsLinks = "";
        if ($pageRenderer->isGoogleFont($headerFontFamily) && isset($headerFontFamily) && $headerFontFamily != "AvenirLTStd-Heavy") {
            $fontLink = str_replace(" ", "+", $headerFontFamily) .":400,600,700";
            $fontsLinks .= $fontLink;
        }
        if ($pageRenderer->isGoogleFont($bodyFontFamily) && isset($bodyFontFamily) && $bodyFontFamily != $headerFontFamily && $bodyFontFamily != "AvenirLTStd-Roman") {
            $fontLink = str_replace(" ", "+", $bodyFontFamily).":400,600,700";
            $fontsLinks .= "|$fontLink";
        }
    @endphp

    @if(!empty($fontsLinks))
        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css?family={{ $fontsLinks }}" rel="stylesheet">
    @endif

    <link rel="stylesheet" href="{{ asset('/css/fontawesome/css/all.css') }}">
    <link rel="stylesheet" href="{{ asset('/css/temp-buildable-public.css') }}">
    <link href="{{ asset('/css/app.css')}} " rel="stylesheet">
    <link href="{{ asset('/css/animate.css')}} " rel="stylesheet">

    @include('buildable-overrides.append-styles')

@endsection

@section('content')

    <script> var pageData = {!! $pageRenderer->getPageData() !!}; </script>

    @if(config('buildable.custom-header'))
        @include('buildable-overrides.custom-header')
    @else
        @include('buildable::header-partial')
    @endif

    <div id="page_div" class="page-content">

        @foreach($pageRenderer->getComponentBuilderGroups() as $order => $group)

            <div class="group group-{{ $order }} {{ $group['slug'] }}-group group-of-{{ count($group['rows']) }} {{ (count($group["rows"]) % 2 == 0 ? "group-of-even" : "group-of-odd") }} {{$group['angledTop'] ? 'angled-top-group' : ''}} {{$group['angledBottom'] ? 'angled-bottom-group' : ''}}">

                @foreach($group['rows'] as $componentBuilder)

                    <component :is="'{{ $componentBuilder->getTagName() }}'" component-data="{{ $componentBuilder->getComponentData() }}"
                                row-classes="{{ $componentBuilder->getClasses() }}" row-id="{{ $componentBuilder->getAnchor() }}" row-index="{{ $componentBuilder->getIndex() }}"
                                background-image-style="{{ $componentBuilder->getBackgroundImageStyle() }}">
                    </component>

                @endforeach

            </div>

        @endforeach

    </div>

    @if(config('buildable.custom-footer'))
        @include('buildable-overrides.custom-footer')
    @else
        @include('buildable::footer-partial')
    @endif

@endsection

@section('add_bottom_scripts')

    @if($pageRenderer->hasMaps)
        <script>
            window.mapsReady = false;
            window.setMapsReady = function() {
                window.mapsReady = true;
            }
        </script>
        <script async defer
                src="//maps.googleapis.com/maps/api/js?key={{ config('buildable.google-maps-api-key') }}&callback=setMapsReady"
                type="text/javascript">
        </script>
    @endif

    <script src="{{ asset('/js/public/app.js') }}"></script>

    @if(isset($googleAnalyticsTrackingId))
        {{--Google Analytics: change UA-XXXXX-X to be your site's ID--}}
        <script src="{{ asset('js/public/footer-google-analytics.js') }}"></script>
    @endif

    {{--@foreach($pageRenderer->getPageScripts() as $pageScriptGroup)--}}

        {{--@foreach($pageScriptGroup as $pageScript)--}}
            {{--<script src="{{ asset('/js/public/' . $pageScript . '.js') }}"></script>--}}
        {{--@endforeach--}}

    {{--@endforeach--}}

@endsection
