<?php

/**
 * Buildable Routes
 * --------------------
 *
 * These routes will be bootstrapped in
 * from Buildable's Service Provider
 * unless they are already cached
 */

/**
 * Buildable API Routes
 * --------------------
 */
Route::middleware(['api', 'authenticate'])->group(function() {
    Route::group(['prefix' => 'api'], function () {
        // Pages
        Route::resource('buildable_pages', 'App\Http\Controllers\buildable\BuildablePageController')->only([
            'index', 'show', 'store', 'update', 'destroy'
        ]);
        Route::put('buildable_pages/make_homepage/{buildablePage}', 'App\Http\Controllers\buildable\BuildablePageController@makeHomepage');
        Route::put('buildable_pages/unset_active_user/{buildablePage}', 'App\Http\Controllers\buildable\BuildablePageController@unsetActiveUser');
        Route::put('buildable_pages/update_status_mask/{buildablePage}', 'App\Http\Controllers\buildable\BuildablePageController@updateStatusMask');
        // Posts
        Route::resource('buildable_posts', 'App\Http\Controllers\buildable\BuildablePostController')->only([
            'index', 'show', 'store', 'update', 'destroy'
        ]);
        // Files
        Route::resource('buildable_files', 'App\Http\Controllers\buildable\BuildableFileController')->only([
            'index', 'show', 'store', 'update', 'destroy'
        ]);
        // Categories
        Route::resource('buildable_categories', 'App\Http\Controllers\buildable\BuildableCategoryController')->only([
            'index', 'show', 'store', 'update', 'destroy'
        ]);
        // Tags
        Route::resource('buildable_tags', 'App\Http\Controllers\buildable\BuildableTagController')->only([
            'index', 'show', 'store', 'update', 'destroy'
        ]);
        // Components
        Route::resource('buildable_components', 'App\Http\Controllers\buildable\BuildableComponentController')->only([
            'show', 'store', 'update', 'destroy'
        ]);
        // VaultComponents
        Route::resource('buildable_vault_components', 'App\Http\Controllers\buildable\BuildableVaultComponentController')->only([
            'index', 'show', 'store', 'update', 'destroy'
        ]);
        // Settings
        Route::resource('buildable_settings', 'App\Http\Controllers\buildable\BuildableSettingController')->only([
            'index'
        ]);
        Route::put('buildable_settings', 'App\Http\Controllers\buildable\BuildableSettingController@update');
        Route::get('buildable_json_by_category', 'App\Http\Controllers\buildable\BuildableSettingController@buildableJsonByCategory');
        // Activities
        Route::resource('buildable_activity', 'App\Http\Controllers\buildable\BuildableActivityController')->only([
            'index', 'show', 'destroy'
        ]);
        // Menus
        Route::resource('buildable_menus', 'App\Http\Controllers\buildable\BuildableMenuController')->only([
            'index', 'store'
        ]);
        Route::put('buildable_menus', 'App\Http\Controllers\buildable\BuildableMenuController@update');
    });
});

/**
 * Barnacle Form Submission Routes
 * ------------------------------
 */
Route::middleware(['api', 'throttle:5,20'])->group(function() {
   Route::post('api/forms/contact-general', 'App\Http\Controllers\buildable\BuildableUtilityController@contactFormGeneral');
   Route::post('api/forms/contact-sales', 'App\Http\Controllers\buildable\BuildableUtilityController@contactFormSales');
});


/**
 * Buildable Admin Route
 * -------------------------
 */
Route::middleware(['web', 'auth', 'insert-token'])->group(function() {
    Route::get('/admin/{vue_capture?}', 'Fivable\Buildable\Controllers\BuildableAdminController@index')->where('vue_capture', '[\/\w\@\%\.-]*');
});


/**
 * Buildable Public Routes
 * -------------------------
 */
Route::middleware(['web'])->group(function() {
    Route::get('/', 'App\Http\Controllers\buildable\BuildablePageController@showHomepage');
    // Pages
    Route::get('/{slug}', 'App\Http\Controllers\buildable\BuildablePageController@showPublic');
    // Posts
    Route::get('posts/{buildablePost}', 'App\Http\Controllers\buildable\BuildablePostController@showPublic');
});

