<?php

namespace Fivable\Buildable\Policies;

use App\User;
use Fivable\Buildable\Models\BuildableTag;
use Illuminate\Auth\Access\HandlesAuthorization;

class BuildableTagPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the User can view this BuildableTag
     * @param User $user
     * @param BuildableTag $buildableTag
     * @return bool
     */
    public function view(User $user, BuildableTag $buildableTag)
    {
        return true;
    }

    /**
     * Determine whether the User can view an index of BuildableTags
     *
     * @param  App\User  $user
     * @param  BuildableTag  $buildableTag
     * @return bool
     */
    public function viewIndex(User $user, BuildableTag $buildableTag) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can create BuildableTags
     * @param  App\User  $user
     * @return bool
     */
    public function create(User $user) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can update this BuildableTag
     * @param  App\User  $user
     * @param  BuildableTag  $buildableTag
     * @return bool
     */
    public function update(User $user, BuildableTag $buildableTag) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can delete the BuildableTag
     * @param  App\User  $user
     * @param  BuildableTag  $buildableTag
     * @return mixed
     */
    public function delete(User $user, BuildableTag $buildableTag) : bool
    {
        return true;
    }
}
