<?php

namespace Fivable\Buildable\Policies;

use App\User;
use Fivable\Buildable\Models\BuildableFile;
use Illuminate\Auth\Access\HandlesAuthorization;

class BuildableFilePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the User can view an index of BuildableFiles
     * @param  User  $user
     * @param  BuildableFile  $buildableFile
     * @return bool
     */
    public function viewIndex(User $user) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can view this BuildableFile
     * @param  User  $user
     * @param  BuildableFile  $buildableFile
     * @return bool
     */
    public function view(User $user, BuildableFile $buildableFile) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can create BuildableFiles
     * @param  User  $user
     * @return bool
     */
    public function create(User $user) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can update this BuildableFile
     * @param  User  $user
     * @param  BuildableFile  $buildableFile
     * @return bool
     */
    public function update(User $user, BuildableFile $buildableFile) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can delete this BuildableFile
     * @param  User  $user
     * @param  BuildableFile  $buildableFile
     * @return bool
     */
    public function delete(User $user, BuildableFile $buildableFile) : bool
    {
        return true;
    }
}
