<?php

namespace Fivable\Buildable\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BuildableVaultComponent extends Model
{
    use SoftDeletes;

    /* Columns that are mass-assignable */
    protected $fillable = ['component_name', 'component_slug', 'vault_name', 'vault_slug', 'content'];
    /* Columns to convert to Carbon */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];


    /** Relationships
     * ----------------*/

    // TODO: Add some kind of relationship to the BuildableFiles in the component content?

    /**
     * Get the BuildableComponents that are linked to this BuildableVaultComponent
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function components()
    {
        return $this->hasMany('Fivable\Buildable\Models\BuildableComponent');
    }
}
