jQuery(document).ready( function($) {

    var blogs = $(".row.card-row.post-excerpt.light-theme.primary-accent.bg-fit").toArray();
    var numberOfBlogs = blogs.length;

    // Only run this logic if there are blogs on the page (i.e., we are on the archive page)
    if (numberOfBlogs > 0) {
        var mod = numberOfBlogs % 5;

        // Adjust the size of the last element (or two)
        // depending on how many extra elements there are
        switch (mod) {
            case 1:
            case 4:
                // There is one card left over
                var blog = $(blogs[numberOfBlogs - 1]);
                blog.addClass('extra-post');
                break;

            case 2:
                // There are two 33% cards left over
                var blog1 = $(blogs[numberOfBlogs - 1]);
                var blog2 = $(blogs[numberOfBlogs - 2]);

                blog1.addClass('extra-post');
                blog2.addClass('extra-post');
                break;

            default:
                // All cards fit!
                break;
        }
    }

    $("#header + .page-content .group-1:not(.text-group):not(.story-group) > .row.bg-full:first-child").first().append("<div class='content-chevron'><i class='fa fa-chevron-down fa-2x' aria-hidden='true'></i></div>");

    $(".page-content").on("click", ".content-chevron", function() {
        $('html, body').animate({
            scrollTop: $(window).height()
        }, "slow");
    });

    $(".menu-button").click( function() {
        $("#header").prev(".mobile-menu").find(".nav").addClass("active");
    });

    $(".menu-close").click( function() {
        $("#header").prev(".mobile-menu").find(".nav").removeClass("active");
    });

    $(".event-opener").click( function() {
        var container = $(this).closest(".events-container");
        $(this).next(".event").slideDown();
        if ($(this).hasClass("active")) {
            $(this).removeClass("active");
            $(this).next(".event.active").removeClass("active").slideUp();
        }
        else {
            $(container).find(".event-container .event-opener.active").removeClass("active")
                .next(".event").removeClass("active").slideUp(400, function () {
                $('html, body').animate({
                    scrollTop: $('.event-opener.active').closest('.event-container').prev('.event-date').offset().top
                }, 400);
            });
            $(this).addClass("active");
            $(this).next(".event").stop().slideDown().addClass("active");
        }
    });

    $(".intro-row").waypoint({
        handler: function(direction) {
            if ($(this.element).find(".intro").hasClass("image-on-left")) {
              $(this.element).find(".intro .content").addClass("animated fadeInRight").css("visibility", "visible");
            }
            else {
              $(this.element).find(".intro .content").addClass("animated fadeInLeft").css("visibility", "visible");
            }
        },
        offset: "75%"
    });

    $(".side-1").waypoint({
        handler: function(direction) {
            if ($(this.element).find(".content").length > 0) {
                $(this.element).find(".content").addClass("animated fadeInLeft").css("visibility", "visible");
            }
        },
        offset: "75%"
    });

    $(".side-2").waypoint({
        handler: function(direction) {
            if ($(this.element).find(".content").length > 0) {
                $(this.element).find(".content").addClass("animated fadeInRight").css("visibility", "visible");
            }
        },
        offset: "75%"
    });

    $(".icon_feature_row-row").waypoint({
        handler: function(direction) {
            var h1 = $(this.element).find("h1.title");
            var content = $(this.element).find(".row");
            $(h1).addClass("animated fadeInUp").css("visibility", "visible");
            $(content).addClass("animated fadeInUp").css("visibility", "visible");
        },
        offset: "75%"
    });

    $(".marketing_row-row").waypoint({
        handler: function(direction) {
            var content = $(this.element).find(".title-paragraph-button");
            $(content).addClass("animated fadeInUp").css("visibility", "visible");
        },
        offset: "75%"
    });

    $(".percentage_infographic-row").waypoint({
        handler: function(direction) {
            this.disable();
            $(this.element).find(".value .number").each(function () {
                $(this).closest(".infographic").find(".percentage-bar").css("width", $(this).text() + "%");
                $(this).prop('Counter',0).animate({
                    Counter: $(this).text()
                }, {
                    duration: 3000,
                    easing: 'swing',
                    step: function (now) {
                        $(this).text(Math.ceil(now));
                    }
                });
            });
        },
        continuous: false,
        offset: "75%"
    });

    $(".latest_news").waypoint({
        handler: function(direction) {
            if ($(this.element).is(".slider")) {
                if ($(this.element).find(".news-card").length > 0) {
                    $(this.element).find(".news-card.card-1, .news-card.card-2, .icon-container").addClass("animated fadeInRight").css("visibility", "visible");
                }
            }
        },
        offset: "75%"
    });

    $(".slider .icon-container").click( function() {
        var container = $(this).closest(".slider");
        var forward = $(this).is(".forward");

        if ($(container).is(".latest_news")) {
            var cardClasses = ".news .news-card";
        }
        else {
            var cardClasses = ".events .event-card";
        }

        var minNumber = 1;
        var maxNumber = $(cardClasses).last().data("number");

        $(container).find(cardClasses + ":visible").each( function(i, card) {
            var number = $(card).data("number");

            if ($(window).width() < 800) {
                var forwardNumber = number + 1;
                var backNumber = number - 1;
                var animationClasses = "";
            }
            else {
                var forwardNumber = number + 2;
                var backNumber = number - 2;
                var animationClasses = "animated fadeInRight";
            }

            $(card).hide();

            if (!!forward) {
                $(container).find(cardClasses + ".card-" + forwardNumber).addClass(animationClasses).css({"visibility": "visible", "display": "block"});
            }
            else {
                $(container).find(cardClasses + ".card-" + backNumber).addClass(animationClasses).css({"visibility": "visible", "display": "block"});
            }
        });

        var firstVisibleNumber = $(cardClasses + ":visible").first().data("number");
        var lastVisibleNumber = $(cardClasses + ":visible").last().data("number");

        if (firstVisibleNumber == minNumber || lastVisibleNumber == maxNumber) {
            $(this).hide();
        }

        if (firstVisibleNumber > minNumber) {
            $(container).find(".icon-container.back").css("display", "flex");
        }

        if (lastVisibleNumber < maxNumber) {
            $(container).find(".icon-container.forward").css("display", "flex");
        }

    });
});