var $j = jQuery.noConflict();

(function( $ ) {
    'use strict';

    $(window).on(function() {

        // Array of all accordion-rows
        var accordionRows = $(".accordion-row");
        $.each(accordionRows, function(i, row) {
            $(row).find(".accordion .content").hide();
            $(row).find(".accordion .content").first().addClass("active").show();
            $(row).find(".accordion .label").first().addClass("active").find("span.chevron").addClass("rotate");
        });

        $(".accordion .label").click( function() {
            // Only target this accordion-row
            var row = $(this).closest(".row.accordion-row");
            if ($(this).hasClass("active")) {
                $(this).removeClass("active");
                $(this).next(".content.active").removeClass("active").slideUp();
                $(this).find("span.chevron").removeClass("rotate");
            }
            else {
                $(row).find(".accordion .label.active").removeClass("active")
                    .find(".chevron").removeClass("rotate");
                $(row).find(".accordion .content.active").removeClass("active").slideUp();
                $(this).addClass("active");
                $(this).next(".content").stop().slideToggle().addClass("active");
                $(this).find("span.chevron").addClass("rotate");
            }
        });

        var countdownDate = $(".countdown .fc-wrapper").data("date");
        if (!!countdownDate) {
            var date = new Date(countdownDate);
            var now = new Date();
            var dif = date.getTime() - now.getTime();
            if (dif >= 0) {
                var countDown = true;
            }
            else {
                // hide counter
            }

            var clock = $(".countdown .fc-wrapper .fc").FlipClock(dif/1000, {
                clockFace: 'DailyCounter',
                countdown: countDown
            });
        }

        $(document).click(function(e) {
            if (!$(e.target).is(".modal, .modal *")) {
                if ($('.modal').is(':visible')) {
                    $('.modal-mask').hide();
                }
            }
        });

        $(".modal a.close").click( function(e) {
            e.preventDefault();
            $(this).closest(".modal-mask").hide();
        });

        jQuery(".photo_gallery > .image-container").click( function(e) {
            console.log('photo_gallery click event line 66 public.js');
            e.stopPropagation();
            var index = jQuery(this).data("image");
            jQuery(this).closest(".photo_gallery").find(".modal-mask").show().css("display", "table");
            jQuery(this).closest(".photo_gallery").find(".modal-image").hide();
            jQuery(this).closest(".photo_gallery").find(".modal-image.slide-" + index).show().css("display", );

            if (index == 1) {
                jQuery(this).closest(".photo_gallery").find(".modal .previous").hide();
                jQuery(this).closest(".photo_gallery").find(".modal .next").show();
            }
            else if (index == jQuery(this).closest(".photo_gallery").find(".modal-image").length) {
                jQuery(this).closest(".photo_gallery").find(".modal .previous").show();
                jQuery(this).closest(".photo_gallery").find(".modal .next").hide();
            }
            else {
                jQuery(this).closest(".photo_gallery").find(".modal .previous").show();
                jQuery(this).closest(".photo_gallery").find(".modal .next").show();
            }
        });

        jQuery(".photo_gallery .modal .previous").click( function(e) {
            e.preventDefault();
            var index = jQuery(this).closest(".modal").find(".modal-image:visible").data("slide") - 1;
            jQuery(this).closest(".photo_gallery").find(".modal-image").hide();
            jQuery(this).closest(".photo_gallery").find(".modal-image.slide-" + index).show();
            if (index == 1) {
                jQuery(this).closest(".photo_gallery").find(".modal .previous").hide();
            }
            else if (index == jQuery(this).closest(".photo_gallery").find(".modal-image").length) {
                jQuery(this).closest(".photo_gallery").find(".modal .next").hide();
            }
            else {
                jQuery(this).closest(".photo_gallery").find(".modal .next").show()
            }
        });

        jQuery("body").keyup( function(e) {
            if (jQuery('.modal').is(':visible')) {
                var index = jQuery(".modal:visible").find(".modal-image:visible").data("slide");
                if (e.keyCode == 27) {
                    jQuery(".modal-mask:visible").hide();
                }
                else if (e.keyCode == 37) {
                    if (index > 1) {
                        var newIndex = index - 1;
                    }
                }
                else if (e.keyCode == 39) {
                    if (index < jQuery(".photo_gallery .modal-image").length) {
                        var newIndex = index + 1;
                    }
                }
                if (!!newIndex) {
                    jQuery(".modal:visible .modal-image").hide();
                    jQuery(".modal:visible .modal-image.slide-" + newIndex).show();

                    if (newIndex == 1) {
                        jQuery(".modal:visible .previous").hide();
                    }
                    else if (newIndex == jQuery(".photo_gallery .modal-image").length) {
                        jQuery(".modal:visible .next").hide();
                    }
                    else {
                        jQuery(".modal:visible .previous").show();
                        jQuery(".modal:visible .next").show();
                    }
                }
            }
        });

        jQuery(".photo_gallery .modal .next").click( function(e) {
            e.preventDefault();
            var index = jQuery(this).closest(".modal").find(".modal-image:visible").data("slide") + 1;
            jQuery(this).closest(".photo_gallery").find(".modal-image").hide();
            jQuery(this).closest(".photo_gallery").find(".modal-image.slide-" + index).show();
            if (index == 1) {
                jQuery(this).closest(".photo_gallery").find(".modal .previous").hide();
            }
            else if (index == jQuery(this).closest(".photo_gallery").find(".modal-image").length) {
                jQuery(this).closest(".photo_gallery").find(".modal .next").hide();
            }
            else {
                jQuery(this).closest(".photo_gallery").find(".modal .previous").show()
            }
        });

        $(".page-content .filter ul.dropdown").hide().css("visibility", "visible");

        $(".row").on("click", ".filter a.dropdown-toggle", function(e) {
            e.stopPropagation();
            $(".filter .dropdown").not($(this).next(".dropdown")).hide().closest(".filter").removeClass("open");

            if ($(this).next(".dropdown").is(":visible")) {
                $(this).next(".dropdown").hide();
                $(this).closest(".filter").removeClass("open");
            }
            else {
                $(this).next(".dropdown").show();
                $(this).closest(".filter").addClass("open");
            }
        });

        $(".school_locator .search-filter .filter-search").hide();

        $(".school_locator .radio-input-container input[type=radio]").click( function() {
            if ($(this).is("#search_address_school")) {
                $(this).closest(".search-filter").find(".filter-search").hide();
                $(this).closest(".search-filter").find(".filter-search input").val("");
                $(this).closest(".search-filter").find(".search").show();

                if ($(this).closest(".list").find(".schools-list .school-info:visible").length != $(this).closest(".list").find(".schools-list .school-info").length) {
                    $(this).closest(".search-filter").find(".reset-filter .reset a.reset-map").click();
                }
            }
            else if ($(this).is("#filter_name_school")) {
                $(this).closest(".search-filter").find(".search").hide();
                $(this).closest(".search-filter").find(".search input").val("");
                $(this).closest(".search-filter").find(".filter-search").show();

                if ($(this).closest(".list").find(".schools-list .school-info:visible").length != $(this).closest(".list").find(".schools-list .school-info").length) {
                    $(this).closest(".search-filter").find(".reset-filter .reset a.reset-map").click();
                }
            }
            checkEmptyState($(this).closest(".list").find(".schools-list .school-info:visible"));
        });

        $(".row.school_locator-row").on("keyup", ".filter-search input", function() {
            var search = $(this).val().toLowerCase();

            $(this).closest(".list").find(".schools-list .school-info").each( function(i, school) {
                var schoolName = $(school).find(".header .name h4").html().toLowerCase();
                if (schoolName.indexOf(search) == -1) {
                    $(school).hide();
                }
                else {
                    $(school).show();
                }
            });

            if (!!$(this).closest(".list").find(".schools-list .school-info:visible").length) {
                filterMapMarkers(slMap, $(this).closest(".list").find(".schools-list .school-info:visible"), $(this).closest(".row"));
            }
            else {
                checkEmptyState($(this).closest(".list").find(".schools-list .school-info:visible"));
            }
        });

        $(".row").on("click", ".filter .dropdown li", function(e) {
            e.stopPropagation();
            var classes = $(this).data("value");

            $(this).closest(".filter").find(".dropdown-toggle").data("value", classes);

            if ($(this).closest(".careers").length > 0) {
                var closestClass = ".careers";

                var baseCSS = ".careers-container .career-card";
            }
            else if ($(this).closest(".school_locator").length > 0) {
                var closestClass = ".school_locator";

                var baseCSS = ".schools-list .school-info"
            }


            var otherFilters = $(this).closest(".filter").siblings();
            var otherClasses = [];

            if (otherFilters.length > 0) {
                $(otherFilters).each( function(i, filter) {
                    if (!!$(filter).find(".dropdown-toggle").data("value")) {
                        otherClasses.push($(filter).find(".dropdown-toggle").data("value"));
                    }
                });
            }

            if (!!classes) {
                $(this).closest(".filter").find(".dropdown-toggle .name").html($(this).html());

                classes = classes.replace(" ", ".");
                classes = "." + classes;

                var hideElems = baseCSS + ":not(" + classes;

                for (var otherClass of otherClasses) {
                    otherClass = otherClass.replace(" ", ".");
                    otherClass = "." + otherClass;
                    hideElems += otherClass;
                }

                hideElems += "):visible";


                // Reset the list of elements first
                if (closestClass == ".school_locator") {
                    filterAddressList(slMap, slMarkers, $(this).closest(closestClass).find(baseCSS));
                }
                else if (closestClass == ".careers") {
                    $(this).closest(closestClass).find(baseCSS).show();
                }

                // Hide all elements that don't match classes provided
                $(this).closest(closestClass).find(hideElems).hide();

                // For the school locator map, only show markers that match visible
                // list elements, then check if the list is empty
                if (closestClass == ".school_locator") {
                    if ($(this).closest(closestClass).find(baseCSS + ":visible").length > 0) {
                        filterMapMarkers(slMap, $(this).closest(closestClass).find(baseCSS + ":visible"), $(this).closest(".row"));
                    }
                    checkEmptyState($(this).closest(closestClass).find(baseCSS + ":visible"));
                }
            }
            else {
                var dropdownToggleName = $(this).closest(".filter").find(".dropdown-toggle .name");
                $(dropdownToggleName).html($(dropdownToggleName).data("name"));

                // Reset the list of elements
                if (closestClass == ".school_locator") {
                    filterAddressList(slMap, slMarkers, $(this).closest(closestClass).find(baseCSS), true);
                    checkEmptyState($(this).closest(closestClass).find(baseCSS + ":visible"));

                    filterMapMarkers(slMap, $(this).closest(closestClass).find(baseCSS + ":visible"), $(this).closest(".row"));
                }
                else if (closestClass == ".careers") {
                    if (otherClasses.length > 0) {
                        var showCards = baseCSS;
                        for (var otherClass of otherClasses) {
                            otherClass = otherClass.replace(" ", ".");
                            otherClass = "." + otherClass;
                            showCards += otherClass;
                        }
                        $(this).closest(closestClass).find(showCards).show()
                    }
                    else {
                        $(this).closest(closestClass).find(baseCSS).show();
                    }
                }
            }

            $(this).closest(".dropdown").hide();
            $(this).closest(".filter").removeClass("open");

            if (closestClass == ".careers" && $(baseCSS + ":visible").length % 3 == 2) {
                $(this).closest(".careers").find(".careers-container").append('<div style="width: calc(33% - 15px);"></div>');
            }
        });

        $(document).click( function() {
            $(".filter .dropdown").hide().closest(".filter").removeClass("open");
        });

        $(".row.careers-row").on("keyup", ".search-filters .search input", function() {
            var search = $(this).val().toLowerCase();
            $(this).closest(".careers").find(".careers-container .career-card").each( function(i, career) {
                var careerData = $(career).find(".career").data("career").toLowerCase();
                if (careerData.indexOf(search) == -1) {
                    $(career).hide();
                }
                else {
                    $(career).show();
                }
            });
            if ($(this).closest(".careers").find(".careers-container .career-card" + ":visible").length % 3 == 2) {
                $(this).closest(".careers").find(".careers-container").append('<div style="width: calc(33% - 15px);"></div>');
            }
        });

        $(".careers-container").each( function(i, career) {
            if ($(this).find(".career-card:visible").length % 3 == 2) {
                $(this).closest(".careers").find(".careers-container").append('<div style="width: calc(33% - 15px);"></div>');
            }
        });

        $(".latest_news.rows").each( function(i, latestNews) {
            if ($(window).width() >= 1024 && $(this).find(".first-card, .news-card").length % 5 == 2) {
                $(this).append('<div style="width: calc(33% - 15px);"></div>');
            }
        });

        // Select all links with hashes
        $('a[href*="#"]')
        // Remove links that don't actually link to anything
            .not('[href="#"]')
            .not('[href="#0"]')
            .click(function(event) {
                // On-page links
                if (
                    location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '')
                    &&
                    location.hostname == this.hostname
                ) {
                    // Figure out element to scroll to
                    var target = $(this.hash);
                    target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
                    // Does a scroll target exist?
                    if (target.length) {
                        // Only prevent default if animation is actually gonna happen
                        event.preventDefault();
                        $('html, body').animate({
                            scrollTop: target.offset().top
                        }, 1000);
                    }
                }
            });


    });

})( jQuery );
