<?php

namespace Fivable\Buildable;

use App\Policies\buildable\BuildableActivityPolicy;
use App\Policies\buildable\BuildableCategoryPolicy;
use App\Policies\buildable\BuildableComponentPolicy;
use App\Policies\buildable\BuildableFilePolicy;
use App\Policies\buildable\BuildableMenuPolicy;
use App\Policies\buildable\BuildablePagePolicy;
use App\Policies\buildable\BuildablePostPolicy;
use App\Policies\buildable\BuildableSettingPolicy;
use App\Policies\buildable\BuildableTagPolicy;
use App\Policies\buildable\BuildableVaultComponentPolicy;
use App\Policies\buildable\UserPolicy;
use App\User;
use Fivable\Buildable\Models\BuildableActivity;
use Fivable\Buildable\Models\BuildableCategory;
use Fivable\Buildable\Models\BuildableComponent;
use Fivable\Buildable\Models\BuildableFile;
use Fivable\Buildable\Models\BuildableMenu;
use Fivable\Buildable\Models\BuildablePage;
use Fivable\Buildable\Models\BuildablePost;
use Fivable\Buildable\Models\BuildableSetting;
use Fivable\Buildable\Models\BuildableTag;
use Fivable\Buildable\Models\BuildableVaultComponent;

class Buildable
{
    /**
     * Instantiate Buildable Class
     */
    public function __construct()
    {
        //
    }

    /**
     * Used by Test Suite to ensure functioning setup
     * @param  string $string
     * @return string
     */
    public function testSetup(string $string)
    {
        return $string;
    }

    /**
     * @param array $otherPolicies
     * @return array
     */
    public static function mergeBuildablePolicies(array $otherPolicies)
    {
        return array_merge($otherPolicies, [
            BuildableActivity::class => BuildableActivityPolicy::class,
            BuildableCategory::class => BuildableCategoryPolicy::class,
            BuildableComponent::class => BuildableComponentPolicy::class,
            BuildableFile::class => BuildableFilePolicy::class,
            BuildableMenu::class => BuildableMenuPolicy::class,
            BuildablePage::class => BuildablePagePolicy::class,
            BuildablePost::class => BuildablePostPolicy::class,
            BuildableSetting::class => BuildableSettingPolicy::class,
            BuildableTag::class => BuildableTagPolicy::class,
            BuildableVaultComponent::class => BuildableVaultComponentPolicy::class,
            User::class => UserPolicy::class,
        ]);
    }
}
