@extends('buildable::default-layout')

@section('title')Not Found @endsection

@section('add_styles')

    @include('buildable-overrides.prepend-styles')

    @php
        $fontsLinks = "";
        if (Fivable\Buildable\Builders\PageRenderer::isGoogleFont($headerFontFamily) && isset($headerFontFamily) && $headerFontFamily != "AvenirLTStd-Heavy") {
            $fontLink = str_replace(" ", "+", $headerFontFamily) .":400,600,700";
            $fontsLinks .= $fontLink;
        }
        if (Fivable\Buildable\Builders\PageRenderer::isGoogleFont($bodyFontFamily) && isset($bodyFontFamily) && $bodyFontFamily != $headerFontFamily && $bodyFontFamily != "AvenirLTStd-Roman") {
            $fontLink = str_replace(" ", "+", $bodyFontFamily).":400,600,700";
            $fontsLinks .= "|$fontLink";
        }
    @endphp

    @if(!empty($fontsLinks))
        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css?family={{ $fontsLinks }}" rel="stylesheet">
    @endif

    <link rel="stylesheet" href="{{ asset('/css/fontawesome/css/all.css') }}">
    <link href="{{ asset('/css/app.css')}} " rel="stylesheet">

    @include('buildable-overrides.append-styles')

@endsection

@section('favicons')
  <!-- Favicons -->
  @if(isset($favicon))
    <!-- Still need to figure out how we're going to do this favicon thing when it's saved in general settings -->
  @else
    @include('buildable-overrides.custom-favicons')
  @endif
@endsection('favicons')

@section('add_top_scripts')

    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
            integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8="
            crossorigin="anonymous">
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/waypoints/4.0.1/jquery.waypoints.min.js?ver=4.9.6"></script>

    <script src="{{ asset('/js/public/script.js') }}"></script>
    <script src="{{ asset('/js/public/helpers.js') }}"></script>
    <script src="{{ asset('/js/public/public.js') }}"></script>
    <script src="{{asset('/js/public/header.js')}}"></script>

    @if(isset($googleAnalyticsTrackingId))
        <script src="{{ asset('/js/public/header-google-analytics.js') }}"></script>
    @endif

@endsection

@section('content')
    @if(config('buildable.custom-header'))
        @include('buildable-overrides.custom-header')
    @else
        @include('buildable::header-partial')
    @endif

    @if(config('buildable.custom-404'))
        @include('buildable-overrides.custom-404')
    @else
        <div id="page_div" class="page-content page-404">
            <div class="group group-1 text-group">
                <div class="row row-1 text-row">
                    <div class="text">
                        <div class="content">
                          <h1 class="big">404</h1>
                          <h5>Page Not Found</h5>
                          <p>Sorry, we can't find what you're looking for.</p>
                          <a class="button" href="/">Go Home</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if(config('buildable.custom-footer'))
        @include('buildable-overrides.custom-footer')
    @else
        @include('buildable::footer-partial')
    @endif

@endsection