@php
    $footerLink1 = json_decode($footerLink1);
    $footerLink2 = json_decode($footerLink2);
@endphp
<div id="footer">
    <div class="logo-and-text">
        @if(!empty($footerLogo))
            <a class="logo-link" href="{{ $footerLogoLink }}"><img id="footer_logo" class="logo" src="{{ json_decode($footerLogo)->url }}" /></a>
        @endif
        @if(!empty($footerText))
            <h4 class="text-link"><a href="{{ $footerLogoLink }}">{{ $footerText }}</a></h4>
        @endif
    </div>
    @if(!empty($footer) && !empty($footer->content))
        <div class="footer-menu">
            <div class="menu-container">
                @foreach($footer->content as $page)
                    <div class="{{ isset($page['parent_id']) ? 'menu-item sub' : 'menu-item' }}">
                        <a href="{{ isset($page['slug']) ? (env('APP_URL') . '/' . ($page['slug'])) : $page['url'] }}">{!! isset($page['customTitle']) ? $page['customTitle'] : $page['title'] !!}</a>
                    </div>
                @endforeach
            </div>
        </div>
    @endif
</div>
<div id="sub_footer">
    <p class="copyright">&copy; {{ $copyrightText }}</p>
    <p class="links">
        @if(!is_null($footerLink1->url) && !is_null($footerLink1->url))
            <a href="{{ $footerLink1->url }}">{{ $footerLink1->text }}</a>
        @endif
        @if(!is_null($footerLink2->url) && !is_null($footerLink2->url))
            |
            <a href="{{ $footerLink2->url }}">{{ $footerLink2->text }}</a>
        @endif
    </p>
</div>
