<?php

namespace Fivable\Buildable\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BuildableTag extends Model
{
    use SoftDeletes;

    /* Columns that are mass-assignable */
    protected $fillable = ['name', 'slug'];
    /* Columns to convert to Carbon */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /** Relationships
     * ----------------*/

    /**
     * Return the BuildablePosts associated with this BuildableTag
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function buildable_posts()
    {
        return $this->belongsToMany('Fivable\Buildable\Models\BuildablePost');
    }
}
