<?php

namespace Fivable\Buildable\Models;

Use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BuildablePageMeta extends Model
{
    /* Columns that are mass-assignable */
    protected $fillable = ['buildable_page_id', 'key', 'value'];


    /** Relationships
     * ----------------*/

    /**
     * Get the BuildableFile this BuildableFileMeta is associated with
     * @return BelongsTo
     */
    public function buildable_page()
    {
        return $this->belongsTo('Fivable\Buildable\Models\BuildablePage');
    }
}
