<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBuildableVaultComponentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('buildable_vault_components', function (Blueprint $table) {
            $table->increments('id');
            $table->string('buildable_component_name');
            $table->string('buildable_component_slug');
            $table->string('name')->unique();
            $table->string('slug')->unique();
            $table->text('content');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('buildable_vault_components');
    }
}
