<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBuildableCategoryBuildablePostTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('buildable_category_buildable_post', function (Blueprint $table) {
            $table->integer('buildable_category_id')->unsigned();
            $table->integer('buildable_post_id')->unsigned();
            $table->timestamps();
            $table->softDeletes();

            $table->primary(['buildable_category_id', 'buildable_post_id'], 'category_post_composite');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('buildable_category_buildable_post');
    }
}
