<?php

namespace Fivable\Buildable\Controllers;

use Fivable\Buildable\Models\BuildableActivity;
use Fivable\Scaffolding\Controllers\ApiController;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class BuildableActivityController extends ApiController
{
    /**
     * Get all (or some) BuildableActivities of all (or some) types
     * @param Request $request
     * @return JsonResponse
     */
    public function index(Request $request) : JsonResponse
    {
        $days = $request->days ?? /*forever*/NULL;
        $types = $request->types ?? /*all*/NULL;

        $this->authorizeForUser($this->user(), 'viewIndex', BuildableActivity::class, $types);

        $selectedQuery = BuildableActivity::indexFor($types, $days);

        return response()->json([
            'activities' => $selectedQuery->get(),
        ]);
    }

    /**
     * Get a specific BuildableActivity
     * @param  BuildableActivity  $buildableActivity
     * @return JsonResponse
     */
    public function show(BuildableActivity $buildableActivity) : JsonResponse
    {
        $this->authorizeForUser($this->user(), 'view', $buildableActivity);

        return response()->json([
            'activity' => $buildableActivity,
        ]);
    }

    /**
     * Soft Delete a specific BuildableActivity
     * @param  BuildableActivity  $buildableActivity
     * @return JsonResponse
     * @throws \Exception
     */
    public function destroy(BuildableActivity $buildableActivity) : JsonResponse
    {
        $this->authorizeForUser($this->user(), 'delete', $buildableActivity);

        $buildableActivity->delete();

        return response()->json([
            'deleted_activity' => $buildableActivity,
        ]);
    }
}
