function getAccentHex(string) {
    if (string.indexOf("light-accent") > -1) {
        return "#FFFFFF";
    }
    else if (string.indexOf("dark-accent") > -1) {
        return "#000000";
    }
    else {
        if (!!_VARIABLES && !!_VARIABLES["primary-color"]) {
            if (string.indexOf("primary-accent") > -1) {
                return _VARIABLES["primary-color"];
            }
            else if (string.indexOf("secondary-accent") > -1) {
                return _VARIABLES["secondary-color"];
            }
            else if (string.indexOf("tertiary-accent") > -1) {
                return _VARIABLES["tertiary-color"];
            }
        }
    }
    return null;
}

function setTextColor(color) {
    var hslColor = hexToHSL(color);
    if (hslColor.l > 50) {
        return "black";
    }
    else {
        return "white";
    }
}

function hexToHSL(hex) {
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);

    var r = parseInt(result[1], 16);
    var g = parseInt(result[2], 16);
    var b = parseInt(result[3], 16);

    r /= 255, g /= 255, b /= 255;
    var max = Math.max(r, g, b), min = Math.min(r, g, b);
    var h, s, l = (max + min) / 2;

    if(max == min){
        h = s = 0; // achromatic
    } else {
        var d = max - min;
        s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
        switch(max) {
            case r: h = (g - b) / d + (g < b ? 6 : 0); break;
            case g: h = (b - r) / d + 2; break;
            case b: h = (r - g) / d + 4; break;
        }
        h /= 6;
    }

    s = s*100;
    s = Math.round(s);
    l = l*100;
    l = Math.round(l);
    h = Math.round(360*h);

    var colorInHSL = {
        h: h,
        s: s,
        l: l
    };

    // I think this HSL may be wrong??? Seems like the Hue is off
    return colorInHSL;
}

var _VARIABLES = {};

// jQuery(document).ready( function($) {
//     if (!!translation_array) {
//         $.getJSON(translation_array.templateUrl + "/js/variables.json", function(data) {
//             if (!!data) {
//                 _VARIABLES = data;
//                 initSchoolLocatorMap();
//             }
//         });
//     }
// });