
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

import Vue from 'vue';

import _ from 'lodash';

import App from './App.vue';

import 'es6-promise/auto';

import { sync } from 'vuex-router-sync';
import store from './store/index';
import router from './router/index';
import moment from 'moment';
import VueMomentJs from 'vue-momentjs';
import { Chrome } from 'vue-color';
import wysiwyg from 'vue-wysiwyg';
import vue2Dropzone from 'vue2-dropzone';

const unsync = sync(store, router);

window._FONTS = require('../../buildable-fonts.json');

Vue.use(VueMomentJs, moment);
Vue.use(wysiwyg, {});

Vue.component('sidebar', require('./components/Sidebar.vue'));
Vue.component('bottom-bar', require('./components/BottomBar.vue'));
Vue.component('dropdown', require('./components/Dropdown.vue'));
Vue.component('filter-dropdown', require('./components/FilterDropdown.vue'));
Vue.component('menu-builder', require('./components/MenuBuilder.vue'));
Vue.component('color-dropdown', require('./components/ColorDropdown.vue'));
Vue.component('input-field', require('./components/InputField.vue'));
Vue.component('image-selector', require('./components/ImageSelector.vue'));
Vue.component('array-props', require('./components/ArrayProps.vue'));
Vue.component('custom-colors', require('./components/customization/Colors.vue'));
Vue.component('custom-fonts', require('./components/customization/Fonts.vue'));
Vue.component('custom-header', require('./components/customization/Header.vue'));
Vue.component('custom-footer', require('./components/customization/Footer.vue'));
Vue.component('custom-posts', require('./components/customization/Posts.vue'));
Vue.component('custom-menus', require('./components/customization/Menus.vue'));
Vue.component('category-visual', require('./components/component-categories/Visual.vue'));
Vue.component('category-grouped', require('./components/component-categories/Grouped.vue'));
Vue.component('category-short-format', require('./components/component-categories/ShortFormat.vue'));
Vue.component('category-long-format', require('./components/component-categories/LongFormat.vue'));
Vue.component('category-functional', require('./components/component-categories/Functional.vue'));
Vue.component('category-stackable', require('./components/component-categories/Stackable.vue'));
Vue.component('component-content', require('./components/component-tabs/Content.vue'));
Vue.component('component-colors', require('./components/component-tabs/Colors.vue'));
Vue.component('component-background', require('./components/component-tabs/Background.vue'));
Vue.component('component-additional-options', require('./components/component-tabs/AdditionalOptions.vue'));
Vue.component('file-modal', require('./components/FileModal.vue'));
Vue.component('modal', require('./components/Modal.vue'));
Vue.component('file-library-modal', require('./components/FileLibraryModal.vue'));

Vue.component('chrome-picker', Chrome);
Vue.component('vue-dropzone', vue2Dropzone);

const app = new Vue({
    el: '#app',
    template: '<app></app>',
    components: { App },
    store,
    router
});
