<?php

namespace Fivable\Buildable;

use Fivable\Buildable\Commands\RewriteVariables;
use Illuminate\Support\ServiceProvider;

class BuildableServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services
     * @return void
     */
    public function boot()
    {
        // Specify where to publish Buildable config and views for customization
        // 'buildable' is set as the tag for these vendor files, allowing you
        // to publish config and views with vendor:publish --tag=buildable
        $this->publishes([
            __DIR__.'/config/buildable.php' => config_path('buildable.php'),
            __DIR__.'/scripts/local-reset-buildable.sh' => base_path(),
            __DIR__.'/policies_to_publish' => base_path('app/Policies/buildable'),
            __DIR__.'/controllers_to_publish' => base_path('app/Http/Controllers/buildable'),
            __DIR__.'/views' => resource_path('views/vendor/buildable'),
            __DIR__.'/assets' => resource_path('assets/vendor/buildable'),
            __DIR__.'/../package.json' => base_path('package.json'),
            __DIR__.'/../webpack.mix.js' => base_path('webpack.mix.js')
        ], 'buildable');

        // Load routes unless they are already cached
        $this->loadRoutesFrom(__DIR__.'/routes.php');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__.'/migrations');

        // Load views
        $this->loadViewsFrom(__DIR__.'/views', 'buildable');

        // Add artisan commands if necessary
        $this->commands([
            RewriteVariables::class,
        ]);
    }

    /**
     * Register the application services.
     * @return void
     */
    public function register()
    {
        // Create alias to Buildable class for BuilbableFacade to use
        $this->app->alias(Buildable::class, 'buildable');

        // Merge the default Buildable config file with
        // published config so that you only need to
        // define the keys you plan to overwrite
        $this->mergeConfigFrom(__DIR__.'/config/buildable.php', 'buildable');
    }
}
