#!/usr/bin/env bash
# Remove published vendor files, pull changes into Satis,
# update Buildable in this location, and newly publish what you removed

YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m'

if [ ! -L ./vendor/fivable/buildable ]; then
    printf "${YELLOW}No symlink found. Creating a symlink from ${BLUE}~/local-git/buildable-laravel ${YELLOW}to ${BLUE}./vendor/fivable/buildable${NC}\n"

   ln -s ~/local-git/fivable/buildable-laravel/ ./vendor/fivable/buildable
fi

# Remove Config
#sudo rm config/buildable.php
# Remove Controllers
sudo rm -R app/Http/Controllers/buildable
# Remove Policies
sudo rm -R app/Policies/buildable
# Remove Assets
sudo rm -R resources/assets/vendor/buildable
# Remove Views
sudo rm -R resources/views/vendor/buildable
# Remove package.json
sudo rm package.json
# Remove webpack.mix.js
sudo rm webpack.mix.js

# Publish any removed publishable vendor files
php artisan vendor:publish --tag=buildable

# Compile all the things
php artisan rewrite:variables
yarn run dev

#because of course
composer dumpautoload -o
