<?php

namespace Fivable\Buildable\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BuildableMenuMeta extends Model
{
    /* Columns that are mass-assignable */
    protected $fillable = ['buildable_menu_id', 'key', 'value'];


    /** Relationships
     * ----------------*/

    /**
     * Get the BuildableFile this BuildableFileMeta is associated with
     * @return BelongsTo
     */
    public function buildable_menu()
    {
        return $this->belongsTo('Fivable\Buildable\Models\BuildableMenu');
    }
}
