<?php

use Fivable\Buildable\Models\BuildableSetting;
use Illuminate\Database\Migrations\Migration;

class SeedSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // CUSTOMIZATION - Colors
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Primary Color",
            "slug" => "primary-color",
            "value" => "#3366CC"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Secondary Color",
            "slug" => "secondary-color",
            "value" => "#343D46"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Tertiary Color",
            "slug" => "tertiary-color",
            "value" => "#C0C5CE"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Quaternary Color",
            "slug" => "quaternary-color",
            "value" => "#757C80"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Quinary Color",
            "slug" => "quinary-color",
            "value" => "#1F232A"
        ]);

        // CUSTOMIZATION - Fonts
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Font Size Multiplier",
            "slug" => "font-size-multiplier",
            "value" => 1
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Font Family",
            "slug" => "header-font-family",
            "value" => "Bitter"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Body Font Family",
            "slug" => "body-font-family",
            "value" => "Libre Franklin"
        ]);

        // CUSTOMIZATION - Header
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Logo",
            "slug" => "header-logo",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Mobile Header Logo",
            "slug" => "mobile-header-logo",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Text",
            "slug" => "header-text",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Options",
            "slug" => "header-options",
            "value" => "fixed_height"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Height",
            "slug" => "header-height",
            "value" => 100
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Color",
            "slug" => "header-color",
            "value" => "primary-color"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Link Color",
            "slug" => "header-link-color",
            "value" => "light"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Button Color",
            "slug" => "header-button-color",
            "value" => "light"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Sub-Nav Color",
            "slug" => "header-sub-nav-color",
            "value" => "primary-color"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Sub-Nav Accent Color",
            "slug" => "header-sub-nav-accent-color",
            "value" => "secondary-color"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Header Sub-Nav Link Color",
            "slug" => "header-sub-nav-link-color",
            "value" => "light"
        ]);

        // CUSTOMIZATION - Footer
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Footer Logo",
            "slug" => "footer-logo",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Footer Text",
            "slug" => "footer-text",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Footer Logo Link",
            "slug" => "footer-logo-link",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Footer Height",
            "slug" => "footer-height",
            "value" => 100
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Footer Color",
            "slug" => "footer-color",
            "value" => 'dark'
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Sub-Footer Color",
            "slug" => "sub-footer-color",
            "value" => 'primary-color'
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Copyright Text",
            "slug" => "copyright-text",
            "value" => "2010 - 2018 Fivable, LLC"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Footer Link 1",
            "slug" => "footer-link-1",
            "value" => '{ "text": null, "url": null }'
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Footer Link 2",
            "slug" => "footer-link-2",
            "value" => '{ "text": null, "url": null }'
        ]);

        // CUSTOMIZATION - Posts
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Posts Title",
            "slug" => "posts-title",
            "value" => "Blog"
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Posts Description",
            "slug" => "posts-description",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 1,
            "name" => "Posts Placeholder Images",
            "slug" => "posts-placeholder-images",
            "value" => null
        ]);

        // GENERAL SETTINGS
        BuildableSetting::create([
            "type_mask" => 2,
            "name" => "Site Name",
            "slug" => "site-name",
            "value" => "Buildable Site"
        ]);
        BuildableSetting::create([
            "type_mask" => 2,
            "name" => "Site Description",
            "slug" => "site-description",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 2,
            "name" => "SEO Keywords",
            "slug" => "seo-keywords",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 2,
            "name" => "SEO Robots",
            "slug" => "seo-robots",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 2,
            "name" => "Google Analytics Tracking ID",
            "slug" => "google-analytics-tracking-id",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 2,
            "name" => "Stackable URL",
            "slug" => "stackable-url",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 2,
            "name" => "Stackable API Key",
            "slug" => "stackable-api-key",
            "value" => null
        ]);
        BuildableSetting::create([
            "type_mask" => 2,
            "name" => "Favicon",
            "slug" => "favicon",
            "value" => null
        ]);

        // SUPER ADMIN SETTINGS
        BuildableSetting::create([
            "type_mask" => 4,
            "name" => "Buildable JSON",
            "slug" => "buildable-json",
            "value" => null
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $seededSettingSlugs = [
            'primary-color',
            'secondary-color',
            'tertiary-color',
            'quaternary-color',
            'quinary-color',
            'font-size-multiplier',
            'header-font-family',
            'body-font-family',
            'header-logo',
            'header-text',
            'header-options',
            'header-height',
            'header-color',
            'header-link-color',
            'header-button-color',
            'header-sub-nav-color',
            'header-sub-nav-accent-color',
            'header-sub-nav-link-color',
            'footer-logo',
            'footer-text',
            'footer-logo-link',
            'footer-height',
            'footer-color',
            'sub-footer-color',
            'copyright-text',
            'footer-link-1',
            'footer-link-2',
            'posts-title',
            'posts-description',
            'posts-placeholder-images',
            'site-name',
            'site-description',
            'seo-keywords',
            'seo-robots',
            'google-analytics-tracking-id',
            'stackable-url',
            'stackable-api-key',
            'favicon',
            'buildable-json',
        ];
        BuildableSetting::whereIn('slug', $seededSettingSlugs)->delete();
    }
}
