## fivable/buildable

Known on Bitbucket as the repo 'buildable-laravel', the 'fivable/buildable' Composer package can be used to include Buildable functionality in a brand new Laravel project, or on top of any existing Laravel project. This is an incarnation of Fivable's Wordpress plug-in "Buildable".



### Adding fivable/buildable package to Laravel Project

* Go to packages.fivable.com and add the repository to your Laravel project's composer.json (don't copy outer curly braces, they represent the existing composer.json).

* Run the command `composer require fivable/buildable`

* Run the commands `php artisan vendor:publish --tag=buildable` and `php artisan vendor:publish --tag=scaffolding`

* Open 'config/scaffolding.php' and set 'get_views_from' to 'buildable'

* Make sure your database is set up in .env, and run php artisan migrate.

* Make App\User extend Fivable\Buildable\Models\BuildableUser OR Fivable\Scaffolding\Models\ScaffoldingUser (BuildableUser extends ScaffoldingUser).

* In App\Providers\AuthServiceProvider add the line `$this->policies = Buildable::mergeBuildablePolicies($this->policies);` to the boot method above registerPolicies. Make sure you "use Fivable\Buildable\Buildable".

* Set APP_URL (in .env) to the base url for the app, IT IS USED!

* Also set AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY, AWS_DEFAULT_REGION, AWS_BUCKET, and AWS_URL in .env to enable S3 file storage.

* Run yarn to install yarn dependencies.

* Run `composer dumpautoload -o` 100 times.

* You will probably have to tinker with some permissions at some point, possibly immediately depending on environment, see below.

  

### Troubleshooting Yarn/RewriteVariables/Permissions Issues

If having permissions issues try these steps:

* `sudo chmod 774 -R *`
* `sudo chown ubuntu:www-data -R *`

If having permissions issues related only to _variables.scss (for customizations changes) try these:

* `sudo chmod 774 -R ./resources/assets/vendor/buildable/sass/assets/_variables.scss`
* `sudo chown ubuntu:www-data -R ./resources/assets/vendor/buildable/sass/assets/_variables.scss`

If having node problems (especially completely vague npm-pointing-blame kinds of problems):

* Check 'nodejs' (legacy) is not installed, especially if you're on ubuntu - if it's there, uninstall it.
* Create a symlink for /usr/local/bin/node in /usr/bin/node

Additional possible solutions if you're hosed

* `rm -R yarn.lock`, `rm -R node_modules`, `yarn cache clean --force`, then `yarn`



### Updating / Resetting / Deploy Scripts

TODO: Detail 'reset-buildable', 'local-reset-buildable', 'ppr', and 'pull-prod.sh'. Also, put all of these scripts into buildable-laravel to be published to new projects, some currently only exist in barnacle_marketing. Also discuss the process of having to commit changes within project (i.e. barnacle_marketing).



### Resetting Satis

**Satis is the composer-based package repository that we use for Fivable's very own composer packages.**

To reset Satis you can SSH into Dori and run the globally available command `reset-satis`. This will pull from the master branch on Git and update the versions held in our satis repository at packages.fivable.com. If you need to now update the version of fivable/buildable in your project, run 'composer update fivable/buildable'. If you need to republish vendor files, make sure to keep track of any changes you had already made (be careful), and remove the relevant currently published vendor files before running the vendor:publish command again.

If you need to update the version of Scaffolding used by Buildable, you must tag a new version number. **Use semantic versioning**. If you make changes to Scaffolding and do not tag a new version, Buildable will not get the changes, because it will not pull 'dev-master' branch of fivable/scaffolding from Satis.



### Satis Versioning (Important!)

The reset-satis script (on Dori) will remove the buildable distribution folder before resetting. This means that only tagged versions AND the very latest dev-master commit will be available. You will be able to tell if you look in the distribution folder that this is the case. This is perfect because it allows us to use tagged versions indefinitely without worrying we will not have a maintained Satis distribution, but also allows us to test dev commits in staging environments! So, if something is needed long-term **TAG IT!**