<?php

namespace Fivable\Buildable\Traits;

trait IsPublishable {

    /** Status Helpers
     * ----------------*/

    /**
     * Determine whether or not this Publishable Object is public
     * @return bool
     */
    public function isPublic()
    {
        return !!($this->status_mask & 1);
    }

    /**
     * Determine whether or not this Publishable Object is private
     * @return bool
     */
    public function isPrivate()
    {
        return !!($this->status_mask & 2);
    }

    /**
     * Determine whether or not this Publishable Object is password protected
     * @return bool
     */
    public function isPasswordProtected()
    {
        return !!($this->status_mask & 4);
    }

    /**
     * Determine whether or not this Publishable Object is a draft
     * @return bool
     */
    public function isDraft()
    {
        return !!($this->status_mask & 8);
    }

    /**
     * Determine whether or not this Publishable Object is deleted
     * @return bool
     */
    public function isDeleted()
    {
        return !!($this->status_mask & 128);
    }
}
