<?php

namespace Fivable\Buildable\Policies;

use App\User;
use Fivable\Buildable\Models\BuildableSetting;
use Illuminate\Auth\Access\HandlesAuthorization;

class BuildableSettingPolicy
{
    use HandlesAuthorization;

    /**
     * If User is Superadmin, allow all
     * @param $user
     * @return bool|NULL
     */
    public function before(User $user) : ?bool
    {
        if ($user->isSuperadmin()) {
            return true;
        }
    }

    /**
     * Determine whether the User can view an index of BuildableSettings
     * @param  User  $user
     * @param  string|NULL
     * @return bool
     */
    public function viewIndex(User $user, string $type = NULL) : bool
    {
        switch ($type) {
            case 'superadmin':
            case NULL:
                return false;
            case 'general':
                return $user->isAdmin();
            case 'customization':
                return true;
        }
    }

    /**
     * Determine whether the User can update this BuildableSetting
     * @param  User  $user
     * @param  string $type_mask
     * @return bool
     */
    public function update(User $user, string $type_mask) : bool
    {
        switch (BuildableSetting::staticGetTypeString($type_mask)) {
            case 'superadmin':
            case NULL:
                return false;
            case 'general':
                return $user->isAdmin();
            case 'customization':
                return true;
        }
    }

    /**
     * Determine whether the User can access Buildable JSON by category
     * @param User $user
     * @return bool
     */
    public function buildableJsonByCategory(User $user) : bool
    {
        return true;
    }
}
