<?php

namespace Fivable\Buildable\Policies;

use App\User;
use Fivable\Buildable\Models\BuildablePage;
use Illuminate\Auth\Access\HandlesAuthorization;

class BuildablePagePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the User can view an index of BuildablePages
     * @param  User  $user
     * @return bool
     */
    public function viewIndex(User $user) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can view this BuildablePage
     * @param  User  $user
     * @param  BuildablePage  $buildablePage
     * @return bool
     */
    public function view(User $user, BuildablePage $buildablePage) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can create BuildablePages
     * @param  User  $user
     * @return bool
     */
    public function create(User $user) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can update this BuildablePage
     * @param  User  $user
     * @param  BuildablePage  $buildablePage
     * @return bool
     */
    public function update(User $user, BuildablePage $buildablePage) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can unset the active user of this Page (must be themselves)
     * @param User $user
     * @param BuildablePage $buildablePage
     * @return bool
     */
    public function unsetActive(User $user, BuildablePage $buildablePage) : bool
    {
        return $user->id === $buildablePage->active_user_id;
    }

    /**
     * Determine whether the user can delete this BuildablePage
     * @param  User  $user
     * @param  BuildablePage  $buildablePage
     * @return bool
     */
    public function delete(User $user, BuildablePage $buildablePage) : bool
    {
        return true;
    }
}
