<?php

namespace Fivable\Buildable\Policies;

use App\User;
use Fivable\Buildable\Models\BuildableCategory;
use Illuminate\Auth\Access\HandlesAuthorization;

class BuildableCategoryPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the User can view this BuildableCategory
     * @param User $user
     * @param BuildableCategory $buildableCategory
     * @return bool
     */
    public function view(User $user, BuildableCategory $buildableCategory)
    {
        return true;
    }

    /**
     * Determine whether the User can view an index of BuildableCategories
     *
     * @param  App\User  $user
     * @param  BuildableCategory  $buildableCategory
     * @return bool
     */
    public function viewIndex(User $user, BuildableCategory $buildableCategory) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can create BuildableCategories
     * @param  App\User  $user
     * @return bool
     */
    public function create(User $user) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can update this BuildableCategory
     * @param  App\User  $user
     * @param  BuildableCategory  $buildableCategory
     * @return bool
     */
    public function update(User $user, BuildableCategory $buildableCategory) : bool
    {
        return true;
    }

    /**
     * Determine whether the user can delete the BuildableCategory
     * @param  App\User  $user
     * @param  BuildableCategory  $buildableCategory
     * @return bool
     */
    public function delete(User $user, BuildableCategory $buildableCategory) : bool
    {
        return true;
    }
}
