<?php

namespace Fivable\Buildable\Policies;

use App\User;
use Fivable\Buildable\Models\BuildableActivity;
use Illuminate\Auth\Access\HandlesAuthorization;

class BuildableActivityPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the User can view the BuildableActivity
     * @param  User  $user
     * @param  BuildableActivity  $buildableActivity
     * @return bool
     */
    public function view(User $user, BuildableActivity $buildableActivity) : bool
    {
        $canSeeFeed = !($user->isEditor());
        $canSeeAudit = $user->isSuperadmin();

        return ($buildableActivity->isFeed() && $canSeeFeed) || ($buildableActivity->isAudit() && $canSeeAudit);
    }

    /**
     * Determine whether the User can view an index of specified types of BuildableActivity
     * @param User $user
     * @param array|NULL $types
     * @return bool
     */
    public function viewIndex(User $user, array $types = NULL)
    {
        switch ($types) {
            case 'feed':
                return !($user->isEditor());
            case 'audit':
            case /*all*/NULL:
                return $user->isSuperadmin();
        }
    }

    /**
     * Determine whether the User can delete this BuildableActivity.
     * @param  User  $user
     * @return bool
     */
    public function delete(User $user) : bool
    {
        return $user->isSuperadmin();
    }
}
