<?php

namespace Fivable\Buildable\Models;

use Fivable\Buildable\Traits\IsPublishable;
Use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BuildablePost extends Model
{
    use SoftDeletes;
    use IsPublishable;

    /* Columns that are mass-assignable */
    protected $fillable = ['slug', 'user_id', 'title', 'content', 'status'];
    /* Columns to convert to Carbon */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];


    /** Relationships
     * ----------------*/

    /**
     * Get the User who created this POST
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Get the BuildableCategories associated with this BuildablePost
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function categories()
    {
        return $this->belongsToMany('Fivable\Buildable\Models\BuildableCategory');
    }

    /**
     * Get the BuildableTags associated with this BuildablePost
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function tags()
    {
        return $this->belongsToMany('Fivable\Buildable\Models\BuildableTag');
    }


    /** Laravel Overrides
     * ---------------------*/

    /**
     * Use BuildablePost's slug for Route Model Binding
     * @return string
     */
    public function getRouteKeyName()
    {
        return 'slug';
    }
}
