<?php

namespace Fivable\Buildable\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class BuildableComponent extends Model
{
    use SoftDeletes;

    /* Columns that are mass-assignable */
    protected $fillable = ['name', 'slug', 'content', 'vault_component_id', 'page_id', 'order', 'is_grouped'];
    /* Columns to convert to Carbon */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];
    /* Columns to cast */
    protected $casts = ['content' => 'array'];


    /** Relationships
     * ----------------*/

    /**
     * Get the BuildablePage this BuildableComponent belongs to
     * @return BelongsTo
     */
    public function page()
    {
        return $this->belongsTo('Fivable\Buildable\Models\BuildablePage');
    }

    /**
     * Return the BuildableVaultComponent associated with this BuildableComponent
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function vault_component()
    {
        return $this->belongsTo('Fivable\Buildable\Models\BuildableVaultComponent');
    }


    /** Helper Functions
     * --------------------*/

    /**
     * Return whether or not this BuildableComponent is linked to a BuildableVaultComponent
     * @return bool
     */
    public function isLinked()
    {
        return !is_null($this->vault_component);
    }
}
