<?php

namespace Fivable\Buildable\Controllers;

use Fivable\Buildable\Models\BuildableTag;
use Fivable\Scaffolding\Controllers\ApiController;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class BuildableTagController extends ApiController
{
    /**
     * Get all BuildableTag
     * @return JsonResponse
     */
    public function index() : JsonResponse
    {
        $this->authorizeForUser($this->user(), 'viewIndex', BuildableTag::class);

        $tags = BuildableTag::all();

        return response()->json([
            'tags' => $tags,
        ]);
    }

    /**
     * Create a new BuildableTag
     * @param Request $request
     * @return JsonResponse
     */
    public function store(Request $request) : JsonResponse
    {
        $this->authorizeForUser($this->user(), 'create', BuildableTag::class);

        $newTags = BuildableTag::create($request->all());

        return response()->json([
            'new_tag' => $newTags,
        ]);
    }

    /**
     * Retrieve a specific BuildableTag
     * @param  BuildableTag  $buildableTag
     * @return JsonResponse
     */
    public function show(BuildableTag $buildableTag) : JsonResponse
    {
        $this->authorizeForUser($this->user(), 'view', $buildableTag);

        return response()->json([
            'tag' => $buildableTag,
        ]);
    }

    /**
     * Update a specific BuildableTag
     * @param  Request  $request
     * @param  BuildableTag  $buildableTag
     * @return JsonResponse
     */
    public function update(Request $request, BuildableTag $buildableTag) : JsonResponse
    {
        $this->authorizeForUser($this->user(), 'update', $buildableTag);

        $buildableTag->update($request->all());

        return response()->json([
            'updated_tag' => $buildableTag->fresh(),
        ]);
    }

    /**
     * Delete a specific BuildableTag
     * @param  BuildableTag  $buildableTag
     * @return JsonResponse
     * @throws \Exception
     */
    public function destroy(BuildableTag $buildableTag) : JsonResponse
    {
        $this->authorizeForUser($this->user(), 'delete', $buildableTag);

        $buildableTag->delete();

        return response()->json([
            'deleted_tag' => $buildableTag,
        ]);
    }
}
