let mix = require('laravel-mix');

let fs = require('fs');

/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */

mix.js('resources/assets/vendor/buildable/js/admin/app.js', 'public/js')
   .js('resources/assets/vendor/buildable/js/public/app.js', 'public/js/public')
   .js('resources/assets/vendor/buildable/js/public/header.js', 'public/js/public')
   .js('resources/assets/vendor/buildable/js/public/helpers.js', 'public/js/public')
   .js('resources/assets/vendor/buildable/js/public/script.js', 'public/js/public')
   .js('resources/assets/vendor/buildable/js/public/public.js', 'public/js/public')
   .js('resources/assets/vendor/buildable/js/public/header-google-analytics.js', 'public/js/public')
   .js('resources/assets/vendor/buildable/js/public/footer-google-analytics.js', 'public/js/public')
   .sass('resources/assets/vendor/buildable/sass/admin-app.scss', 'public/css')
   .sass('resources/assets/vendor/buildable/sass/app.scss', 'public/css')
   .copy('resources/assets/vendor/buildable/css/animate.css', 'public/css')
    .copy('resources/assets/vendor/buildable/js/public/css/temp-buildable-public.css', 'public/css') // THIS IS TEMPORARY, my styles aren't set up right and this fixes a few things while I convert some components and wait for Urban to HALP
   .copyDirectory('resources/assets/vendor/buildable/css/fontawesome', 'public/css/fontawesome')
   .copyDirectory('resources/assets/vendor/buildable/images', 'public/images');

// If the project overrides the default Buildable Fonts (as they appear in customization settings)
if (fs.existsSync('resources/assets/js/admin/override-fonts.js')) {
  mix.js('resources/assets/js/admin/override-fonts.js', 'public/js');
}

// If the project has custom fonts
if (fs.existsSync('resources/assets/fonts')) {
  mix.copyDirectory('resources/assets/fonts', 'public/css/custom-fonts');
}

// If the project adds to the image assets
if (fs.existsSync('resources/assets/images')) {
  mix.copyDirectory('resources/assets/images', 'public/images');
}

// If the project uses custom favicons
if (fs.existsSync('resources/assets/favicons')) {
  mix.copyDirectory('resources/assets/favicons', 'public/favicons');
}

if (fs.existsSync('resources/assets/scss/append-styles.scss')) {
  mix.sass('resources/assets/scss/append-styles.scss', 'public/css');
}
