<?php

namespace Fivable\Buildable\Traits;

trait HasMasks {

    /**
     * Get an array of the bits in a role_mask
     * @param $roleMask
     * @return array|NULL
     */
    public static function staticMaskArray($roleMask)
    {
        $range = env('HIGHEST_BITMASK', 256);
        $masks = [];

        for ($i = 1; $i <= $range; $i *= 2) {
            !($roleMask & $i) ?: array_push($masks, $i);
        }

        return empty($masks) ? NULL : $masks;
    }
}
