<?php

namespace Fivable\Buildable\Policies;

use App\User;
use Fivable\Buildable\Models\BuildableVaultComponent;
use Illuminate\Auth\Access\HandlesAuthorization;

class BuildableVaultComponentPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the User can view an index of BuildableVaultComponents
     * @param  User  $user
     * @param  BuildableVaultComponent  $buildableVaultComponent
     * @return bool
     */
    public function viewIndex(User $user, BuildableVaultComponent $buildableVaultComponent) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can view this BuildableVaultComponent
     * @param  User  $user
     * @param  BuildableVaultComponent  $buildableVaultComponent
     * @return bool
     */
    public function view(User $user, BuildableVaultComponent $buildableVaultComponent) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can create a BuildableVaultComponent
     * @param  User  $user
     * @return bool
     */
    public function create(User $user) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can update this BuildableVaultComponent
     * @param  User  $user
     * @param  BuildableVaultComponent  $buildableVaultComponent
     * @return bool
     */
    public function update(User $user, BuildableVaultComponent $buildableVaultComponent) : bool
    {
        return true;
    }

    /**
     * Determine whether the User can delete this BuildableVaultComponent
     * @param  User  $user
     * @param  BuildableVaultComponent  $buildableVaultComponent
     * @return bool
     */
    public function delete(User $user, BuildableVaultComponent $buildableVaultComponent) : bool
    {
        return true;
    }
}
